# Advanced Usage

Whilst implementing Skin Shortcuts in a basic way is relatively easy, the script has a lot of advanced options to either provide more features to your users, or to customise the experience provided to them.

Many of these options are based on providing an 'overrides.xml' file with your skin. [See here for details](./overrides.md).

## Managing backgrounds

Details of how to use Skin Shortcuts to let the user select from a range of available backgrounds or browse for an image, and integrate this into your skin.

[Read More](./Managing%20backgrounds.md)

## Managing widgets

Details of how to use Skin Shortcuts to let the user select from a range of available widgets, and integrate this into your skin.

[Read More](./Managing%20widgets.md)

## Additional submenus or other menus

Details of how to build more than one submenu per main menu item, or how to build additional menus unlinked to a main menu item.

[Read More](./Additional%20submenu.md)

## Providing a vertical menu

Details of alternative build method useful for deploying a vertical menu with submenu integrated into it.

[Read More](./Vertical%20menu.md)

## 'Just Select' method

Details of method to use Skin Shortcuts to select a shortcut and return its details to the skin.

[Read More](./Just%20Select.md)

## Templates

Details of template function, allowing Skin Shortcuts to build GUI elements with properties based on menu items. This allows submenus and other items to exist in their own list, enabling such things as animations.

[Read More](./Templates.md)

## Overriding an action

Details of how to override an action in order to provide additional functionality.

[Read More](./Overriding%20an%20action.md)

## Overriding icons

Details of how to override the default icons Skin Shortcuts provides for available shortcuts.

[Read More](./Overriding%20icons.md)

## Overriding labels

Details of how to override the default label Skin Shortcuts provides for available shortcuts.

[Read More](./Overriding%20labels.md)

## Additional shortcuts to select from

Details of how to add additional shortcuts to the select shortcut dialog for the user to choose from.

[Read More](./Additional%20shortcuts.md)

## Required shortcuts

Details of how to specify that a particular shortcut must be in the users menu.

[Read More](./Required%20shortcuts.md)

## Check for shortcut

Details of how to get the script to check whether a particular shortcut is in their menu.

[Read More](./Check%20for%20shortcut.md)

## Custom shortcut properties

Details of how to provide additional properties to user-selected shortcuts.

[Read More](./Custom%20shortcut%20properties.md)

## Custom shortcut property patterns

Details of how to add custom shortcut properties with information from other properties to menu items.

[Read More](./Property%20patterns.md)

## Warn on deleting shortcut

Details of how to warn the user, or get their consent, before a particular shortcut is deleted.

[Read More](./Warn%20on%20deleting%20shortcut.md)

## Force settings link

Details of how to force Skin Shortcuts to add a link to settings to users menus if it does not exist.

[Read More](./Force%20settings%20link.md)

See also [Getting Started](../started/Getting%20Started.md) notes regarding shortcuts to settings.

## Provide thumbnails

Details of how to provide thumbnails for the user to choose from.

[Read More](./Provide%20thumbnails.md)

## Customise groupings of shortcuts

Details of how to customise the groupings that are shown to the user when they select a shortcut or widget.

[Read more](./Custom%20groupings.md)

## Changing menu items from outside of the management dialog

Details of methods available for customising menu items outside of the management dialog.

[Read More](./External%20editing.md)

## Context menu

Details of how to enable and customise the context menu within the management dialog.

[Read More](./Context%20menu.md)

***Quick links*** - [Readme](../../../README.md) - [Getting Started](../started/Getting%20Started.md) - [Advanced Usage](./Advanced%20Usage.md)